# Function to plot results
  plot.results <- function(fit, pdf.name, unit, absolute = TRUE) {
    
    setwd(out.dir)
    pdf(file = pdf.name)
    x <- as.array(fit)
    
  # Mean per group
    absolut.x <- x
    absolut.x <- aaply(.data = absolut.x,
                       .margin = 2,
                       .fun = function(y) {
                         cbind("Group 1 (LD-SP/SP)" = y[, 1],
                               "Group 2 (LD-SP/PIP)" = y[, 1] + y[, 2],
                               "Group 3 (LD-PIP/PIP)" = y[, 1] + y[, 3],
                               "Group 4 (LD-PIP/SP)" = y[, 1] + y[, 4])
                       })
    names(dimnames(absolut.x)) <- c("chains", "iterations", "parameters")
    
    if(absolute == TRUE) print(
      mcmc_areas(absolut.x,
                 prob = .95,
                 prob_outer = .99) +
        scale_x_continuous(name = paste0("\n", unit),
                           breaks = -2:6)
    )
    
  # Difference, relative to group 1
    print(
      mcmc_areas(x[, , grep("Group", dimnames(x)[[3]], value = TRUE)],
                 prob = .95,
                 prob_outer = .99) +
        scale_x_continuous(name = paste0("\nDifference in ", unit, ", relative to Group 1"),
                           breaks = -2:6)
    )
    
  # Difference, relative to group 2
    x.rel.to.gr2 <- x
    x.rel.to.gr2 <- aaply(.data = x.rel.to.gr2,
                          .margin = 2,
                          .fun = function(y) {
                            cbind("Group1" = -y[, 2],
                                  # "(Intercept)" = y[, 2] + y[, 1],
                                  "Group3" = y[, 3] - y[, 2],
                                  "Group4" = y[, 4] - y[, 2])
                          })
    names(dimnames(x.rel.to.gr2)) <- c("chains", "iterations", "parameters")
    
    print(
      mcmc_areas(x.rel.to.gr2,
                 prob = .95,
                 prob_outer = .99) +
        scale_x_continuous(name = paste0("\nDifference in ", unit, ", relative to Group 2"),
                           breaks = -2:6)
    )
    
  # Difference, relative to group 3
    x.rel.to.gr3 <- x
    x.rel.to.gr3 <- aaply(.data = x.rel.to.gr3,
                          .margin = 2,
                          .fun = function(y) {
                            cbind("Group1" = -y[, 3],
                                  "Group2" = y[, 2] - y[, 3],
                                  # "(Intercept)" = y[, 3] + y[, 1],
                                  "Group4" = y[, 4] - y[, 3])
                          })
    names(dimnames(x.rel.to.gr3)) <- c("chains", "iterations", "parameters")
    
    print(
      mcmc_areas(x.rel.to.gr3,
                 prob = .95,
                 prob_outer = .99) +
        scale_x_continuous(name = paste0("\nDifference in ", unit, ", relative to Group 3"),
                           breaks = -2:6)
    )
    
  # Difference, relative to group 4
    x.rel.to.gr4 <- x
    x.rel.to.gr4 <- aaply(.data = x.rel.to.gr4,
                          .margin = 2,
                          .fun = function(y) {
                            cbind("Group1" = -y[, 4],
                                  "Group2" = y[, 2] - y[, 4],
                                  "Group3" = y[, 3] - y[, 4]  #, "(Intercept)" = y[, 4] + y[, 1])
                            )
                          })
    names(dimnames(x.rel.to.gr4)) <- c("chains", "iterations", "parameters")
    
    print(
      mcmc_areas(x.rel.to.gr4,
                 prob = .95,
                 prob_outer = .99) +
        scale_x_continuous(name = paste0("\nDifference in ", unit, ", relative to Group 4"),
                           breaks = -2:6)
    )

  # Calculate and plot ranks
    ranked.x <- aaply(absolut.x,
                      2:1,
                      function(y) rank(1 / y[1:4]))
    names(dimnames(ranked.x))[3] <- "parameters"
    print(
      mcmc_intervals(ranked.x,
                     prob = .95,
                     prob_outer = .99) +
        scale_x_continuous(name = "\nRank")
    )
    
    
  # # Calculate and plot relative difference
  #   relative.x <- aaply(x,
  #                       2:1,
  #                       function(y) 10^y[2:4])
  #   names(dimnames(relative.x))[3] <- "parameters"
  #   print(
  #     mcmc_areas(relative.x,
  #                prob = .95,
  #                prob_outer = 0.95) +
  #       scale_x_continuous(name = paste0("\nRelative difference in ", unit, "with group 1"))
  #   )

    dev.off()
    
    print("Bayesian 95%-credible interval for difference with group 4 (percentiles)")
    print(cbind(mean = apply(x.rel.to.gr4, 3, mean),
                t(apply(x.rel.to.gr4, 3, quantile, prob = c(0.025, 0.975)))))
    print("")
    print("Bayesian 95%-credible interval for difference with group 4 (HPD interval)")
    print(t(apply(x.rel.to.gr4, 3, function(x) HPDinterval(obj = as.mcmc(c(x)), prob = 0.95))))
    print("")
    print("Posterior probability that the AUC is lower than that of group 4")
    print(apply(x.rel.to.gr4, 3, function(x) mean(x < 0) ))
    print("")
    print("Posterior probability that the AUC of group 4 is the highest of all")
    print(mean(apply(x.rel.to.gr4, 1:2, function(x) all(x < 0))))
     
  }
  
  
  plot.mean.per.group <- function(fit, unit, xlimits = NULL,
                                  breaks = 2:6, labels = 2:6,
                                  small_ticks = NULL) {
    
    x <- as.array(fit)
    x <- aaply(.data = x,
               .margin = 2,
               .fun = function(y) {
                 cbind("Group 1\n(LD-SP/SP)" = y[, 1],
                       "Group 2\n(LD-SP/PIP)" = y[, 1] + y[, 2],
                       "Group 3\n(LD-PIP/PIP)" = y[, 1] + y[, 3],
                       "Group 4\n(LD-PIP/SP)" = y[, 1] + y[, 4])
               })
    names(dimnames(x)) <- c("chains", "iterations", "parameters")
    
    print(
      mcmc_areas(x,
                 prob = .95,
                 prob_outer = .99) +
        scale_x_continuous(name = paste0("\n", unit),
                           breaks = breaks,
                           labels = labels) +
        expand_limits(x = xlimits) #+
        # theme(axis.text.x = element_text(angle = 45, hjust = 1))
    )
    
  }
  
  
### END OF CODE ###
  